# فرد بلاک شده نتواند از سرویس ها استفاده کند
#

from pyrogram.types import Message , ReplyKeyboardMarkup, InlineKeyboardMarkup, InlineKeyboardButton
from pyrogram import Client , filters, __version__
from pyromod.helpers import ikb, kb, array_chunk
from tcp_latency import latency_point as ping
from colorama import Fore as color
from datetime import datetime
from pyromod import listen

import pymysql.cursors
import time as samisleep
import jdatetime
import psutil
import sys
import re
import random

# ================= AUTO REPLY HELPERS =================
def is_admin(cursor, user_id, owner):
    if user_id == owner:
        return True
    cursor.execute("SELECT 1 FROM admins WHERE user_id=%s", (user_id,))
    return cursor.fetchone() is not None
# =====================================================

# فقط Client ربات
main = Client(
    "main",
    api_id=1025177,
    api_hash="786febd4f38f64feb7ad58a5a032bd63",
    bot_token="5598361773:AAE0zUZZCNTPD9h9pLko3JAY4EISsoytJok"
)

print(color.RED + """\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n
          ,-.
         / \  `.  __..-, O
        :   \ --''_..-'.'
        |    \ .-' `. '.'
        :     \     .` .'
         \     `.  /  . .
          \      `.   '  .
          /.\     `.    \ 
         /||\ `.        `-.\ 
         \||/   ``-.......-`
         |  |
         |__|      """ + color.GREEN + """--------------------------------------""" + color.RED + """
         /||\\      """ + color.GREEN + """|           """ + color.YELLOW + f"""Robot Launched""" + color.GREEN + """           |""" + color.RED + """
        //||\\\\     """ + color.GREEN + """|           """ + color.YELLOW + """Dev : @Sami_Dev + @Mr_Mati """ + color.GREEN + """          |""" + color.RED + """
       //_||_\\\\    """ + color.GREEN + """|                """ + color.YELLOW + f"""v1.0""" + color.GREEN + """                |""" + color.RED + """
      //__||__\\\\   """ + color.GREEN + """--------------------------------------""" + color.RED + """
    _//___||___\\\\_
   '--------------' 
    """)

message_key = InlineKeyboardMarkup(
    [
        [
            InlineKeyboardButton(
                "💠 پاسخ 💠",
                callback_data="reply"
            ),
            InlineKeyboardButton(
                "🚫 بلاک 🚫",
                callback_data="block"
            )
        ]
    ]
)

home_key = ReplyKeyboardMarkup(
    [
        ["👤حساب کاربری👤"],
        ["👨‍💻ارتباط👨‍💻"],
        ["🧾درباره ربات🧾"]
    ],
    resize_keyboard=True
)

admin_key = ReplyKeyboardMarkup(
    [
        ["📊 آمار 📊"],
        ["🏠 رفتن به خانه 🏠"]
    ],
    resize_keyboard=True
)

owner_key = ReplyKeyboardMarkup(
    [
        ["📊 آمار 📊"],
        ["➡️ حذف ادمین ➡️","⬅️ افزودن ادمین ⬅️"],
        ["👤 لیست مدیران 👤"],
        ["✒️پیام همگانی ✒️","🖋 فوروارد همگانی🖋"],
        ["🔒 تنظیم جوین اجباری 🔒"],
        ["⛔️ مسدود کاربر ⛔️","✅ رفع مسدود کاربر ✅"],
        ["📋 لیست پاسخ‌های خودکار"],  # اضافه شد
        ["🏠 رفتن به خانه 🏠"]
    ],
    resize_keyboard=True
)

cancel = ReplyKeyboardMarkup(
    [
        ["↩️ بازگشت ↪️"]
    ],
    resize_keyboard=True
)

verify = ReplyKeyboardMarkup(
    [
        ["✅ اطمینان دارم ✅","❌ اطمینان ندارم ❌"]
    ],
    resize_keyboard=True
)

owner = 1783870790

# ================= توابع کمکی =================
async def is_group_admin(c: Client, chat_id: int, user_id: int) -> bool:
    """بررسی اینکه کاربر ادمین گروه است یا نه"""
    try:
        chat_member = await c.get_chat_member(chat_id, user_id)
        return chat_member.status in ["creator", "administrator"]
    except Exception as e:
        print(f"⚠️ خطا در بررسی ادمین گروه: {e}")
        return False

async def handle_auto_reply(c: Client, m: Message, text: str, cursor, connection, is_group: bool = False):
    """مدیریت پاسخ‌های خودکار"""
    chat_id = m.chat.id
    text_lower = text.lower()
    
    # اگر متن یک دستور است، پاسخ خودکار نده
    commands_list = ["📊 آمار 📊", "🧾درباره ربات🧾", "👤حساب کاربری👤", "👨‍💻ارتباط👨‍💻", 
                    "📋 لیست پاسخ‌های خودکار", "🏠 رفتن به خانه 🏠", "/panel", "/start"]
    
    if text in commands_list or text.startswith('/'):
        return False
    
    print(f"🔍 Checking auto-reply in {'group' if is_group else 'private'} (ID: {chat_id}) for: {text[:50]}")
    
    try:
        cursor.execute("SELECT trigger_word, response_text FROM auto_replies WHERE chat_id=%s AND is_active=1", (chat_id,))
        replies = cursor.fetchall()
        
        print(f"📊 Found {len(replies)} auto-replies for this chat")
        
        matched = []
        for trigger, response in replies:
            if trigger.lower() in text_lower:
                matched.append((trigger, response))
                print(f"✅ Matched: '{trigger}'")
        
        if matched:
            # انتخاب تصادفی یک پاسخ
            trigger, response = random.choice(matched)
            
            # آپدیت آمار
            cursor.execute("UPDATE auto_replies SET use_count = use_count + 1 WHERE chat_id=%s AND trigger_word=%s", 
                         (chat_id, trigger))
            connection.commit()
            
            print(f"🎯 Auto-reply triggered: '{trigger}' -> sending response")
            
            # ارسال پاسخ
            if is_group:
                await m.reply(response, reply_to_message_id=m.id)
            else:
                await m.reply(response)
            return True
            
    except Exception as e:
        print(f"❌ خطا در اجرای پاسخ خودکار: {e}")
        import traceback
        traceback.print_exc()
    
    return False

# ================= HANDLER برای گروه‌ها =================
@main.on_message(filters.group, group=1)
async def handle_groups(c: Client, m: Message):
    """پردازش پیام‌های گروه"""
    if not m.from_user or not m.text:
        return

    chat_id = m.chat.id
    user_id = m.from_user.id
    text = m.text.strip()
    chat_type = m.chat.type

    print(f"\n{'='*50}")
    print(f"👥 GROUP MESSAGE in {chat_type} (ID: {chat_id})")
    print(f"👤 User: {user_id} (@{m.from_user.username if m.from_user.username else 'no-username'})")
    print(f"💬 Text: {text}")
    print(f"{'='*50}")

    connection = pymysql.connect(
        host="localhost",
        user="root",
        password="",
        db="payam",
        charset="utf8mb4"
    )

    with connection.cursor() as cursor:

        # ================= بررسی ادمین ربات =================
        def is_bot_admin(user_id):
            if user_id == owner:
                return True
            cursor.execute("SELECT 1 FROM admins WHERE user_id=%s", (user_id,))
            return cursor.fetchone() is not None

        async def can_manage_auto_reply(c: Client, cursor, user_id: int, chat_id: int) -> bool:
            if user_id == owner:
                return True
            cursor.execute("SELECT 1 FROM admins WHERE user_id=%s", (user_id,))
            if cursor.fetchone():
                return True
            return await is_group_admin(c, chat_id, user_id)

        # ================= افزودن پاسخ خودکار =================
        add_match = re.match(r"^در جواب (.+?) بگو (.+)$", text)
        if add_match:
            trigger = add_match.group(1).strip()
            response = add_match.group(2).strip()
            print(f"🎯 Auto-reply ADD request by {user_id}: '{trigger}' -> '{response}'")

            if not await can_manage_auto_reply(c, cursor, user_id, chat_id):
                await m.reply("⛔️ فقط ادمین ربات یا ادمین گروه می‌توانند پاسخ خودکار ثبت کنند")
                return

            try:
                username = m.from_user.username if m.from_user.username else None
                cursor.execute("""
                    INSERT INTO auto_replies 
                    (chat_id, chat_type, trigger_word, response_text, created_by, created_by_username)
                    VALUES (%s, %s, %s, %s, %s, %s)
                    ON DUPLICATE KEY UPDATE 
                        response_text = VALUES(response_text),
                        created_by_username = VALUES(created_by_username),
                        updated_at = NOW(),
                        is_active = 1
                """, (chat_id, chat_type, trigger, response, user_id, username))
                connection.commit()
                await m.reply(f"✅ پاسخ خودکار در گروه ثبت شد!\n🔹 در جواب «{trigger}» بگو «{response}»")
                print(f"✅ Auto-reply saved in group {chat_id} by {user_id}")
            except Exception as e:
                print(f"❌ Error saving auto-reply: {e}")
                await m.reply("❌ خطا در ثبت")
            finally:
                connection.close()
            return

        # ================= حذف پاسخ خودکار =================
        del_match = re.match(r"^در جواب (.+?) نگو$", text)
        if del_match:
            trigger = del_match.group(1).strip()
            print(f"🗑 Auto-reply DELETE request for: '{trigger}'")

            if not await can_manage_auto_reply(c, cursor, user_id, chat_id):
                await m.reply("⛔️ فقط ادمین ربات یا ادمین گروه می‌توانند پاسخ خودکار حذف کنند")
                return

            try:
                cursor.execute("SELECT created_by_username, use_count FROM auto_replies WHERE chat_id=%s AND trigger_word=%s",
                               (chat_id, trigger))
                reply_info = cursor.fetchone()

                cursor.execute("DELETE FROM auto_replies WHERE chat_id=%s AND trigger_word=%s", (chat_id, trigger))
                connection.commit()

                if cursor.rowcount > 0:
                    username_info = f"\n👤 ثبت شده توسط: @{reply_info[0]}" if reply_info and reply_info[0] else ""
                    use_count_info = f"\n📊 تعداد استفاده: {reply_info[1]} بار" if reply_info and reply_info[1] else ""
                    await m.reply(f"🗑 پاسخ‌های مربوط به «{trigger}» حذف شد{username_info}{use_count_info}")
                    print(f"✅ Auto-reply deleted from group {chat_id} by {user_id}")
                else:
                    await m.reply(f"⚠️ پاسخی برای «{trigger}» یافت نشد")
            except Exception as e:
                print(f"❌ خطا در حذف پاسخ خودکار: {e}")
                await m.reply("❌ خطا در حذف پاسخ خودکار")
            finally:
                connection.close()
            return

        # ================= پاسخ خودکار =================
        if text and not text.startswith(('/', 'در جواب')):
            try:
                # ───── اگر ریپلای روی انسان است → هیچ کاری نکن ─────
                if m.reply_to_message and m.reply_to_message.from_user and not (
                    m.reply_to_message.from_user.is_bot and m.reply_to_message.from_user.id == c.me.id
                ):
                    return  # سکوت کامل

                # ───── حالت ریپلای روی ربات ─────
                if (
                    m.reply_to_message
                    and m.reply_to_message.from_user
                    and m.reply_to_message.from_user.is_bot
                    and m.reply_to_message.from_user.id == c.me.id
                ):
                    # 🔹 متن کاربر که ریپلای کرده
                    user_text = text  # همین متن فعلی پیام m.text
                    cursor.execute("""
                        SELECT response_text
                        FROM auto_replies
                        WHERE trigger_word=%s
                        AND chat_id=%s
                        AND is_active=1
                        ORDER BY updated_at DESC
                        LIMIT 1
                    """, (user_text, chat_id))
                    res = cursor.fetchone()

                    await m.reply(
                        res[0] if res else "فعلا سرور شلوغه بعدا یادم بنداز جوابتو میدم",
                        reply_to_message_id=m.id
                    )
                    return

                # ───── حالت عادی بدون ریپلای ─────
                cursor.execute("""
                    SELECT trigger_word, response_text
                    FROM auto_replies
                    WHERE chat_id=%s AND is_active=1
                """, (chat_id,))
                replies = cursor.fetchall()

                matched = [(t, r) for t, r in replies if t.lower() in text.lower()]
                if matched:
                    trigger, response = random.choice(matched)
                    cursor.execute("""
                        UPDATE auto_replies
                        SET use_count = use_count + 1, last_used = NOW()
                        WHERE trigger_word=%s AND chat_id=%s
                    """, (trigger, chat_id))
                    connection.commit()
                    await m.reply(response, reply_to_message_id=m.id)

            except Exception as e:
                print(f"❌ خطا در اجرای پاسخ خودکار: {e}")


# ================= HANDLER برای چت خصوصی =================
@main.on_message(filters.private, group=0)
async def all(c: Client, m: Message):
    connection = pymysql.connect(
        host="localhost",
        user="root",
        password="",
        db="payam",
        charset=("utf8mb4")
    )
    user_id = m.from_user.id
    text = m.text if m.text else ""
    
    with connection.cursor() as cursor:
        try:
            cursor.execute("SELECT `user_id` FROM `users` WHERE `user_id` = %s", (user_id,))
            userer = cursor.fetchone()
            if userer and int(userer[0]) == user_id:
                pass
        except Exception as e:
            if str(m.from_user.username) == "None":
                username = "None"
            else:
                username = m.from_user.username
            cursor.execute("INSERT INTO `users` (`user_id`, `username`, `firstname`) VALUES (%s, %s, %s)", 
                         (user_id, username, m.from_user.first_name))
            connection.commit()
        
        # بررسی اینکه کاربر ادمین یا مالک است
        is_admin_user = False
        is_owner_user = user_id == owner
        
        cursor.execute("SELECT `user_id` FROM `admins` WHERE `user_id` = %s", (user_id,))
        admin_result = cursor.fetchone()
        if admin_result or is_owner_user:
            is_admin_user = True
        
        # بررسی عضویت در کانال فقط برای کاربران معمولی
        if not is_admin_user:
            cursor.execute("SELECT `channel` FROM `channel` WHERE `id` = 1")
            channel_result = cursor.fetchone()
            
            if channel_result and channel_result[0]:
                channel_username = channel_result[0]
                try:
                    # ابتدا چک می‌کنیم ربات در کانال عضو هست یا نه
                    try:
                        chat = await main.get_chat(f"@{channel_username}")
                    except:
                        await m.reply(f"❌ ربات در کانال @{channel_username} عضو نیست یا کانال وجود ندارد!")
                        return
                    
                    # حالا چک می‌کنیم کاربر عضو کانال هست یا نه
                    try:
                        chat_member = await main.get_chat_member(f"@{channel_username}", user_id)
                        if chat_member.status in ["left", "kicked", "restricted"]:
                            await m.reply(f"💢 برای استفاده از سرویس های ربات شما باید عضو کانال زیر باشید!\n\n🖇 @{channel_username}")
                            return
                    except Exception as e:
                        print(f"خطا در بررسی عضویت: {e}")
                        await m.reply(f"💢 برای استفاده از سرویس های ربات شما باید عضو کانال زیر باشید!\n\n🖇 @{channel_username}")
                        return
                except Exception as e:
                    print(f"خطای کلی در بررسی کانال: {e}")
            else:
                # اگر کانالی تنظیم نشده، اجازه دسترسی می‌دهیم
                pass

        # بررسی بن بودن کاربر
        cursor.execute("SELECT `block` FROM `users` WHERE `user_id` = %s", (user_id,))
        block_result = cursor.fetchone()
        
        if block_result and int(block_result[0]) == 1:
            await m.reply(f"""🖐سلام
🌹با عرض پوزش!

⛔️دسترسی شما به این ربات قطع شد.
✅در صورتی که فکر میکنید به اشتباه از ربات مسدود شده اید، با [مالک](tg://user?id={owner}) ارتباط برقرار کنید.""")
            return

        # ================= AUTO REPLY SYSTEM در چت خصوصی =================
        # ➕ افزودن پاسخ
        add_match = re.match(r"^در جواب (.+?) بگو (.+)$", text)
        if add_match:
            trigger = add_match.group(1).strip()
            response = add_match.group(2).strip()
            
            chat_id = m.chat.id
            
            print(f"🎯 Auto-reply ADD request in private by {user_id}: '{trigger}' -> '{response}'")
            
            # فقط ادمین‌های ربات اجازه دارند
            if not is_admin(cursor, user_id, owner):
                await m.reply("⛔️ فقط ادمین‌های ربات می‌توانند پاسخ خودکار ثبت کنند")
                return

            try:
                username = m.from_user.username if m.from_user.username else None
                cursor.execute("""
                    INSERT INTO auto_replies 
                    (chat_id, chat_type, trigger_word, response_text, created_by, created_by_username)
                    VALUES (%s, %s, %s, %s, %s, %s)
                    ON DUPLICATE KEY UPDATE 
                    response_text = VALUES(response_text),
                    created_by_username = VALUES(created_by_username),
                    updated_at = NOW(),
                    is_active = 1
                """, (chat_id, "private", trigger, response, user_id, username))
                connection.commit()
                
                await m.reply(f"✅ ثبت شد!\n🔹 در جواب «{trigger}» بگو «{response}»")
                print(f"✅ Auto-reply saved in private chat {chat_id}")
                
            except Exception as e:
                print(f"❌ خطا در ثبت پاسخ خودکار: {e}")
                await m.reply("❌ خطا در ثبت پاسخ خودکار")
            return

        # 🗑 حذف پاسخ
        del_match = re.match(r"^در جواب (.+?) نگو$", text)
        if del_match:
            trigger = del_match.group(1).strip()
            chat_id = m.chat.id
            
            print(f"🗑 Auto-reply DELETE request in private for: '{trigger}'")
            
            # فقط ادمین‌های ربات اجازه دارند
            if not is_admin(cursor, user_id, owner):
                await m.reply("⛔️ فقط ادمین‌های ربات می‌توانند پاسخ خودکار حذف کنند")
                return

            try:
                cursor.execute("SELECT created_by_username, use_count FROM auto_replies WHERE chat_id=%s AND trigger_word=%s",
                            (chat_id, trigger))
                reply_info = cursor.fetchone()
                
                cursor.execute("DELETE FROM auto_replies WHERE chat_id=%s AND trigger_word=%s", (chat_id, trigger))
                connection.commit()
                
                if cursor.rowcount > 0:
                    username_info = f"\n👤 ثبت شده توسط: @{reply_info[0]}" if reply_info and reply_info[0] else ""
                    use_count_info = f"\n📊 تعداد استفاده: {reply_info[1]} بار" if reply_info and reply_info[1] else ""
                    await m.reply(f"🗑 پاسخ‌های مربوط به «{trigger}» حذف شد{username_info}{use_count_info}")
                    print(f"✅ Auto-reply deleted from private chat {chat_id}")
                else:
                    await m.reply(f"⚠️ پاسخی برای «{trigger}» یافت نشد")
                    
            except Exception as e:
                print(f"❌ خطا در حذف پاسخ خودکار: {e}")
                await m.reply("❌ خطا در حذف پاسخ خودکار")
            return

        # 🤖 اجرای پاسخ خودکار در چت خصوصی
        if text and not text.startswith('/') and not text.startswith('در جواب'):
            handled = await handle_auto_reply(c, m, text, cursor, connection, is_group=False)
            if handled:
                return
        # ================= END AUTO REPLY =================

        # دستورات مختلف
        if text == "/panel":
            if is_owner_user:
                await m.reply("🔆 مالک عزیز به پنل خود خوش آمدید.", reply_markup=owner_key)
            elif is_admin_user:   
                await m.reply("🔆 ادمین عزیز به پنل خود خوش آمدید.", reply_markup=admin_key)
            else:
                await m.reply("⛔️ شما دسترسی به پنل ندارید.")

        elif text == "👤 لیست مدیران 👤":
            if user_id == owner:
                cursor.execute("SELECT `user_id` FROM `admins`")
                admins = cursor.fetchall()
                base = "👤 لیست مدیران \n\n"
                for admin in admins:
                    try:
                        ad = await main.get_users(int(admin[0]))
                        base = base + f"👨‍💻 [{ad.first_name}](tg://user?id={ad.id})\n"
                    except:
                        continue
                await m.reply(base, disable_web_page_preview=True)

        elif text == "📋 لیست پاسخ‌های خودکار":
            chat_id = m.chat.id
            
            try:
                cursor.execute("""
                    SELECT trigger_word, response_text, created_by_username, use_count, 
                        DATE_FORMAT(created_at, '%%Y/%%m/%%d %%H:%%i')
                    FROM auto_replies
                    WHERE chat_id=%s AND is_active=1
                    ORDER BY use_count DESC, created_at DESC
                    LIMIT 20
                """, (chat_id,))
                rows = cursor.fetchall()
                
                if rows:
                    response_text = "📋 لیست پاسخ‌های خودکار:\n\n"
                    
                    for i, (trigger, reply, creator, use_count, created_date) in enumerate(rows, 1):
                        creator_text = f"@{creator}" if creator else "بدون نام"
                        use_text = f" ({use_count} بار)" if use_count > 0 else ""
                        
                        response_text += f"{i}. **{trigger}**\n"
                        response_text += f"   ➤ {reply[:50]}..." if len(reply) > 50 else f"   ➤ {reply}\n"
                        response_text += f"   👤 {creator_text}{use_text} | 📅 {created_date}\n\n"
                    
                    await m.reply(response_text, disable_web_page_preview=True)
                else:
                    await m.reply("📭 هیچ پاسخ خودکاری ثبت نشده است.")
            except Exception as e:
                print(f"خطا در دریافت لیست: {e}")
                await m.reply("❌ خطا در دریافت لیست")

        elif text == "➡️ حذف ادمین ➡️":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ یوزرنیم یا یوزرآیدی فرد مورد نظر را ارسال کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await msg.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    try:
                        user = await main.get_users(msg.text)
                        cursor.execute("SELECT `user_id` FROM `admins` WHERE `user_id` = %s", (user.id,))
                        admin_exists = cursor.fetchone()
                        
                        if admin_exists:
                            cursor.execute("DELETE FROM `admins` WHERE `user_id` = %s", (user.id,))
                            connection.commit()
                            await msg.reply("✅ فرد مورد نظر از لیست مدیران ربات حذف شد.", reply_markup=owner_key)
                            try:
                                await main.send_message(user.id, "⚜️ شما توسط مالک ربات از مدیریت ربات عزل شدید.", reply_markup=home_key)
                            except:
                                pass
                        else:
                            await msg.reply("⚠️ فرد مورد نظر ادمین نمیباشد", reply_markup=owner_key)
                    except Exception as e:
                        print(f"خطا در حذف ادمین: {e}")
                        await msg.reply("⚠️ خطایی رخ داد یا کاربر یافت نشد.", reply_markup=owner_key)
                                    
        elif text == "⬅️ افزودن ادمین ⬅️":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ یوزرنیم یا یوزرآیدی فرد مورد نظر را ارسال کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await msg.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    try:
                        user = await main.get_users(msg.text)
                        cursor.execute("SELECT `user_id` FROM `admins` WHERE `user_id` = %s", (user.id,))
                        admin_exists = cursor.fetchone()
                        
                        if admin_exists:
                            await msg.reply("⚠️ فرد مورد نظر از قبل ادمین میباشد", reply_markup=owner_key)
                        else:
                            cursor.execute("INSERT INTO `admins` (`user_id`, `username`, `firstname`) VALUES (%s, %s, %s)", 
                                         (user.id, user.username, user.first_name))
                            connection.commit()
                            await msg.reply("✅ فرد مورد نظر مدیر ربات شد.", reply_markup=owner_key)
                            try:
                                await main.send_message(user.id, "⚜️شما توسط مالک ربات ، مدیر ربات شدید ، برای وارد شدن به پنل خود از دستور زیر استفاده کنید.\n\n🔱 /panel", reply_markup=home_key)
                            except:
                                pass
                    except Exception as e:
                        print(f"خطا در افزودن ادمین: {e}")
                        await msg.reply("⚠️ خطایی رخ داد یا کاربر یافت نشد.", reply_markup=owner_key)
                
        elif text == "🏠 رفتن به خانه 🏠":
            await m.reply("🏠 به منوی اصلی بازگشتید.", reply_markup=home_key)
            
        elif text == "✅ رفع مسدود کاربر ✅":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ یوزرنیم یا یوزرآیدی فرد مورد نظر را ارسال کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await msg.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    try:
                        user_id_to_unblock = int(msg.text)
                        cursor.execute("SELECT `block` FROM `users` WHERE `user_id` = %s", (user_id_to_unblock,))
                        block = cursor.fetchone()
                        
                        if not block:
                            await msg.reply("⚠️ فرد مورد نظر در پایگاه داده وجود ندارد.", reply_markup=owner_key)
                        elif int(block[0]) == 0:
                            await msg.reply("⚠️ حساب فرد مورد نظر مسدود نیست.", reply_markup=owner_key)
                        else:
                            cursor.execute("UPDATE `users` SET `block` = %s WHERE `user_id` = %s", (0, user_id_to_unblock)) 
                            connection.commit()
                            await msg.reply("✅ حساب فرد مورد نظر آزاد شد.", reply_markup=owner_key)
                    except ValueError:
                        username = msg.text.replace("@", "") if "@" in msg.text else msg.text
                        cursor.execute("SELECT `user_id`, `block` FROM `users` WHERE `username` = %s", (username,))
                        result = cursor.fetchone()
                        
                        if not result:
                            await msg.reply("⚠️ فرد مورد نظر در پایگاه داده وجود ندارد.", reply_markup=owner_key)
                        elif int(result[1]) == 0:
                            await msg.reply("⚠️ حساب فرد مورد نظر مسدود نیست.", reply_markup=owner_key)
                        else:
                            cursor.execute("UPDATE `users` SET `block` = %s WHERE `username` = %s", (0, username))
                            connection.commit()
                            await msg.reply("✅ حساب فرد مورد نظر آزاد شد.", reply_markup=owner_key)
                            
        elif text == "⛔️ مسدود کاربر ⛔️":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ یوزرنیم یا یوزرآیدی فرد مورد نظر را ارسال کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await msg.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    try:
                        user_id_to_block = int(msg.text)
                        cursor.execute("SELECT `block` FROM `users` WHERE `user_id` = %s", (user_id_to_block,))
                        block = cursor.fetchone()
                        
                        if not block:
                            cursor.execute("INSERT INTO `users` (`user_id`, `username`, `firstname`, `block`) VALUES (%s, %s, %s, %s)", 
                                         (user_id_to_block, "unknown", "unknown", 1))
                            connection.commit()
                            await msg.reply("✅ حساب فرد مورد نظر مسدود شد.", reply_markup=owner_key)
                        elif int(block[0]) == 1:
                            await msg.reply("⚠️ حساب فرد مورد نظر از قبل مسدود بوده است.", reply_markup=owner_key)
                        else:
                            cursor.execute("UPDATE `users` SET `block` = %s WHERE `user_id` = %s", (1, user_id_to_block)) 
                            connection.commit()
                            await msg.reply("✅ حساب فرد مورد نظر مسدود شد.", reply_markup=owner_key)
                    except ValueError:
                        username = msg.text.replace("@", "") if "@" in msg.text else msg.text
                        cursor.execute("SELECT `user_id`, `block` FROM `users` WHERE `username` = %s", (username,))
                        result = cursor.fetchone()
                        
                        if not result:
                            await msg.reply("⚠️ فرد مورد نظر در پایگاه داده وجود ندارد.", reply_markup=owner_key)
                        elif int(result[1]) == 1:
                            await msg.reply("⚠️ حساب فرد مورد نظر از قبل مسدود میباشد.", reply_markup=owner_key)
                        else:
                            cursor.execute("UPDATE `users` SET `block` = %s WHERE `username` = %s", (1, username))
                            connection.commit()
                            await msg.reply("✅ حساب فرد مورد نظر مسدود شد.", reply_markup=owner_key)
                
        elif text == "🔒 تنظیم جوین اجباری 🔒":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ آدرس کانال مورد نظر رو به صورت زیر ارسال کنید.\n\n@channel", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await m.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    if "@" in msg.text:
                        channel = msg.text.replace("@", "")
                        # چک کردن وجود رکورد در جدول
                        cursor.execute("SELECT COUNT(*) FROM `channel` WHERE `id` = 1")
                        count = cursor.fetchone()[0]
                        
                        if count == 0:
                            # اگر رکورد وجود ندارد، insert می‌کنیم
                            cursor.execute("INSERT INTO `channel` (`id`, `channel`) VALUES (1, %s)", (channel,))
                        else:
                            # اگر رکورد وجود دارد، update می‌کنیم
                            cursor.execute("UPDATE `channel` SET `channel` = %s WHERE `id` = %s", (channel, 1))
                        
                        connection.commit()
                        await msg.reply(f"✅ کانال جدید ثبت شد: @{channel}", reply_markup=owner_key)
                    else:
                        await msg.reply("📛 آدرس کانال را همراه با @ بفرستید مانند زیر.\n\n@channel\n\n🚫 به دلیل ارسال نکردن آدرس کانال همراه با @ به پنل بازگشتید.", reply_markup=owner_key)

        elif text == "🖋 فوروارد همگانی🖋":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ پیام خود را فوروارد کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await m.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    msg2 = await main.ask(user_id, "⚠️ آیا از فوروارد کردن پیام اطمینان دارید؟", reply_markup=verify)
                    if msg2.text == "✅ اطمینان دارم ✅":
                        msg1 = await msg.reply("💠 کمی صبر کنید . . .")
                        cursor.execute("SELECT `user_id` FROM `users`")
                        all_users = cursor.fetchall()
                        x = 0
                        y = 0
                        for user in all_users:
                            try:
                                await main.forward_messages(user[0], msg.from_user.id, msg.id)
                                x = x + 1
                            except Exception as e:
                                print(f"خطا در فوروارد: {e}")
                                y = y + 1
                        await msg1.delete()
                        await msg.reply(f"🌐 پیام شما به {x} نفر فوروارد شد و به {y} نفر فوروارد نشد.", reply_markup=owner_key)
                    else:
                        await m.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                        
        elif text == "✒️پیام همگانی ✒️":
            if user_id == owner:
                msg = await main.ask(user_id, "⚠️ پیام خود را ارسال کنید.", reply_markup=cancel)
                if msg.text == "↩️ بازگشت ↪️":
                    await m.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                else:
                    msg2 = await main.ask(user_id, "⚠️ آیا از ارسال پیام اطمینان دارید؟", reply_markup=verify)
                    if msg2.text == "✅ اطمینان دارم ✅":
                        msg1 = await msg.reply("💠 کمی صبر کنید . . .")
                        cursor.execute("SELECT `user_id` FROM `users`")
                        all_users = cursor.fetchall()
                        x = 0
                        y = 0
                        for user in all_users:
                            try:
                                await main.copy_message(user[0], msg.from_user.id, msg.id)
                                x = x + 1
                            except Exception as e:
                                print(f"خطا در ارسال: {e}")
                                y = y + 1
                        await msg1.delete()
                        await msg.reply(f"🌐 پیام شما به {x} نفر ارسال شد و به {y} نفر ارسال نشد.", reply_markup=owner_key)
                    else:
                        await m.reply("🔆 به پنل بازگشتید.", reply_markup=owner_key)
                
        elif text == "📊 آمار 📊":
            if is_admin_user:
                cursor.execute("SELECT COUNT(*) FROM `users`")
                count_result = cursor.fetchone()
                count = count_result[0] if count_result else 0
                
                DateTime = datetime.now()
                year = DateTime.strftime('%Y')
                month = DateTime.strftime('%m')
                day = DateTime.strftime('%d')
                
                shamsi1 = jdatetime.date.fromgregorian(day=int(day), month=int(month), year=int(year))
                shamsi = str(shamsi1).replace("-", "/")
                
                now = datetime.now()
                time_now = now.strftime("%H:%M:%S")
                
                cursor.execute("SELECT `channel` FROM `channel` WHERE `id` = %s", (1,))
                channel_username_result = cursor.fetchone()
                channel_username = channel_username_result[0] if channel_username_result else "کانالی تنظیم نشده"
                
                await m.reply(f"""
        📊 آمار ربات 📊

        - - - - - - - - - - - - - - - - - - -

        💡کانال عضویت اجباری :
        📡 @{channel_username}

        - - - - - - - - - - - - - - - - - - -

        ✉️ آمار گفتگو ها ✉️

        👤 تعداد کاربران : {count}

        - - - - - - - - - - - - - - - - - - -

        📟 آمار سیستم 📟

        ⚙️ RAM : {psutil.virtual_memory().percent}%

        🎛 CPU : {psutil.cpu_percent()}%

        💾 DISK : {psutil.disk_usage("/").percent}%

        🧭 Ping : {int(ping(host="149.154.167.40", port=443))}ms

        - - - - - - - - - - - - - - - - - - -

        📅 آمار ساعت و تاریخ 📅

        🗒 تاریخ میلادی : {year}/{month}/{day}

        🗓 تاریخ شمسی : {shamsi}

        ⏰ ساعت : {time_now}

        - - - - - - - - - - - - - - - - - - -

        🛠 زبان برنامه نویسی : Python
        ⚒ فریم ورک : Pyrogram
        🪛 نسخه زبان برنامه نویسی : v{sys.version.split(" ")[0]}
        🔧 نسخه فریم ورک : v{__version__}
        🔨 نسخه ربات : v1.0

        👨‍💻 Dev : @Sami_Dev + @Mr_Mati
        """)
            else:
                await m.reply("⛔️ شما دسترسی به آمار ندارید.")
                
        elif text == "🧾درباره ربات🧾":
            await m.reply(f"⚜️ این ربات صرفا جهت ارتباط کاربران با [Mati](tg://user?id={owner}) ساخته شده است و در صورت استفاده نادرست از ربات و یا استفاده از داده هایی که برای ربات به صورت اختصاصی نوشته شده است پیگرد قانونی دارد.\n\n-©️- All Rights Developed For Mati Dev -®️-\n\n👨‍💻 Dev : @Sami_Dev + @Mr_Mati ")
            
        elif text == "👤حساب کاربری👤":
            user = m.from_user
            admin_status = "خیر"
            owner_status = "خیر"
            
            if is_admin_user and not is_owner_user:
                admin_status = "بله"
            elif is_owner_user:
                admin_status = "بله"
                owner_status = "بله"
                
            username = f"@{user.username}" if user.username else "ندارید"
            
            await m.reply(f"""👤حساب کاربری شما👤

🏷 نام شما : {user.first_name}
🔗 یوزرآیدی شما : {user.id}
📍 یوزرنیم شما : {username}
👨‍💻 ادمین : {admin_status}
🤴 مالک : {owner_status}

📌 @Mati_Robot""", reply_markup=home_key)
            
        elif text == "👨‍💻ارتباط👨‍💻":
            msg = await main.ask(
                user_id,
                "✅ پیام خود را ارسال کنید.",
                reply_markup=cancel
            )
            if msg.text == "↩️ بازگشت ↪️":
                await m.reply("✅ به منوی اصلی ربات بازگشتید.", reply_markup=home_key)
            else:
                username = f"@{msg.from_user.username}" if msg.from_user.username else "None"
                
                # ارسال به همه ادمین‌ها
                cursor.execute("SELECT `user_id` FROM `admins`")
                admins = cursor.fetchall()
                for admin in admins:
                    try:
                        await main.send_message(admin[0], f"""🔆 پیام جدید 🔆

🔖 پیام :
{msg.text}

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

🏷 Name : {msg.from_user.first_name}
📍Username : {username}
🔗 UserID : {msg.from_user.id}""", reply_markup=message_key)
                    except:
                        pass
                
                # ارسال به مالک
                try:
                    await main.send_message(owner, f"""🔆 پیام جدید 🔆

🔖 پیام : 
{msg.text}

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

🏷 Name : {msg.from_user.first_name}
📍Username : {username}
🔗 UserID : {msg.from_user.id}""", reply_markup=message_key)
                except:
                    pass
                    
                await m.reply("✅ کاربر عزیز پیام شما به پشتیبانی ارسال شد ، در اولین فرصت مدیران ربات به شما پاسخ میدهند.", reply_markup=home_key)
                
        elif text == "/start":
            await m.reply("✅ با سلام ، به ربات پیام رسان خوش آمدید !", reply_markup=home_key)

cancel_query = ReplyKeyboardMarkup(
    [
        ["↩️ بازگشت ↪️"]
    ],
    resize_keyboard=True
)

rem_key = ReplyKeyboardMarkup(
    [
        ["✅ اطمینان دارم ✅","❌ اطمینان ندارم ❌"]
    ],
    resize_keyboard=True
)

@main.on_callback_query()
async def call(client, call):
    data = call.data
    user = call.from_user.id
    connection = pymysql.connect(
        host="localhost",
        user="root",
        password="",
        db="payam",
        charset=("utf8mb4")
    )
    
    with connection.cursor() as cursor:
        if data == "reply":
            text = call.message.text
            try:
                userer = text.split("🔗 UserID : ")[1].split("\n")[0]
                userer = int(userer.strip())
            except:
                await call.answer("خطا در دریافت اطلاعات کاربر", show_alert=True)
                return
                
            msg = await main.ask(call.from_user.id, "💠 پیام خود را برای ارسال به کاربر ارسال کنید.", reply_markup=cancel_query)
            if msg.text == "↩️ بازگشت ↪️":
                await main.send_message(msg.from_user.id, "✅ به منوی اصلی بازگشتید.", reply_markup=home_key)
            else:
                try:
                    await main.send_message(userer, f"⚜️پاسخ از سمت مدیر⚜️\n\n{msg.text}", reply_markup=home_key)
                    await main.send_message(msg.from_user.id, "✅ پیام شما به فرد ارسال شد.", reply_markup=home_key)
                except Exception as e:
                    await main.send_message(msg.from_user.id, f"خطا در ارسال پیام: {e}", reply_markup=home_key)
                    
        elif data == "block":
            text = call.message.text
            try:
                userer = text.split("🔗 UserID : ")[1].split("\n")[0]
                userer = int(userer.strip())
            except:
                await call.answer("خطا در دریافت اطلاعات کاربر", show_alert=True)
                return
                
            msg = await main.ask(call.from_user.id, "🔆 آیا از مسدود کردن فرد اطمینان دارید؟", reply_markup=rem_key)
            if msg.text == "❌ اطمینان ندارم ❌":
                await main.send_message(msg.from_user.id, "✅ به منوی اصلی بازگشتید.", reply_markup=home_key)
            elif msg.text == "✅ اطمینان دارم ✅":
                try:
                    await main.send_message(userer, f"🚫 شما توسط مدیر ربات مسدود شدید.", reply_markup=home_key)
                except:
                    pass
                    
                cursor.execute("SELECT `block` FROM `users` WHERE `user_id` = %s", (userer,))
                block_status = cursor.fetchone()
                
                if not block_status:
                    cursor.execute("INSERT INTO `users` (`user_id`, `username`, `firstname`, `block`) VALUES (%s, %s, %s, %s)", 
                                 (userer, "unknown", "unknown", 1))
                    connection.commit()
                elif int(block_status[0]) == 1:
                    await main.send_message(msg.from_user.id, "🚫 فرد مورد نظر از قبل مسدود است.", reply_markup=home_key)
                else:
                    cursor.execute("UPDATE `users` SET `block` = %s WHERE `user_id` = %s", (1, userer))
                    connection.commit()
                    await main.send_message(msg.from_user.id, "📛 فرد مورد نظر مسدود شد.", reply_markup=home_key)

print(color.GREEN + "\n🤖 ربات در حال راه اندازی...\n" + color.RESET)
main.run()